// // // // // // // // // // // // // // // //
//
//	Heap.h
//
//	erstellt 24.2.98 von Andreas Warnke
//	geändert 25.2.98 von Andreas Warnke
//


	
#ifndef __Heap_h
#define __Heap_h



// // // // // // // // // // // // // // // //
//
//	HeapElement
//

template < class T >

class Heap;

template < class T >

class HeapElement
{
private:
	//	Schlüssel:
	T key;
	
	//	Söhne:
	HeapElement < T > * left;
	HeapElement < T > * right;
	
public:
	//	Konstruktor:
	HeapElement ( T inKey );
	
	//	Destruktor:
	virtual ~HeapElement ();
	
	friend class Heap < T >;
};


	
// // // // // // // // // // // // // // // //
//
//	Heap
//

template < class T >

class Heap
{
private:
	HeapElement < T > * root;

private:
	//	RemoveLeft:
	HeapElement < T > * RemoveLeft ();
	
	//	SiftDown:
	void SiftDown ();
	
	//	DeleteNode
	static void DeleteNode ( HeapElement < T > * inNode );
	
public:
	//	Konstruktor:
	Heap ();
	
	//	Destruktor:
	virtual ~Heap ();
	
	//	Insert
	void Insert ( HeapElement < T > * inNode );
	
	//	DeleteMin
	HeapElement < T > * DeleteMin ();
	
	//	GetMin
	HeapElement < T > * GetMin ();
	
	//	MakeEmpty
	void MakeEmpty ();
};



// // // // // // // // // // // // // // // //
//
//	Element-Konstruktor:
//

template < class T >

HeapElement < T > :: HeapElement ( T inKey )
{
	key = inKey;
	left = NULL;
	right = NULL;
};



// // // // // // // // // // // // // // // //
//
//	Element-Destruktor:
//

template < class T >

HeapElement < T > :: ~HeapElement ()
{
	left = NULL;
	right = NULL;
};



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

template < class T >

Heap < T > :: Heap ()
{
	root = NULL;
};



// // // // // // // // // // // // // // // //
//
//	DeleteNode:
//

template < class T >

void Heap < T > :: DeleteNode ( HeapElement < T > * inNode )
{
	if ( inNode != NULL )
	{
		DeleteNode ( inNode -> left );
		DeleteNode ( inNode -> right );
		delete inNode;
	};
};



// // // // // // // // // // // // // // // //
//
//	GetMin:
//

template < class T >

HeapElement < T > * Heap < T > :: GetMin ()
{
	return root;
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

template < class T >

Heap < T > :: ~Heap ()
{
	DeleteNode ( root );
	root = NULL;
};



// // // // // // // // // // // // // // // //
//
//	MakeEmpty:
//

template < class T >

void Heap < T > :: MakeEmpty ()
{
	DeleteNode ( root );
	root = NULL;
};



// // // // // // // // // // // // // // // //
//
//	Insert:
//

template < class T >

void Heap < T > :: Insert ( HeapElement < T > * inNode )
{
	//	Parametercheck:
	if ( inNode == NULL )
		return;
		
	//	MyRoot:
	HeapElement < T > ** ToMyRoot = & root;
	HeapElement < T > * MyRoot = root;
		
	while ( MyRoot != NULL )
	{
		if ( inNode -> key < MyRoot -> key )
		{
			//	Ersetze den Knoten:
			HeapElement < T > * newInsert = MyRoot;
			inNode -> left = MyRoot -> right;
			inNode -> right = MyRoot -> left;
			*ToMyRoot = inNode;
			ToMyRoot = & ( inNode -> left );
			MyRoot = *ToMyRoot;
			inNode = newInsert;
		}
		else
		{
			//	Tauschen der Teilbäume:
			HeapElement < T > * swap = MyRoot -> left;
			MyRoot -> left = MyRoot -> right;
			MyRoot -> right = swap;
			ToMyRoot = & ( MyRoot -> left );
			MyRoot = *ToMyRoot;
		};
	};
	
	*ToMyRoot = inNode;
	inNode -> left = NULL;
	inNode -> right = NULL; 
};



// // // // // // // // // // // // // // // //
//
//	SiftDown:
//

template < class T >

void Heap < T > :: SiftDown ()
{	
	if ( root == NULL )
		return;

	//	MyRoot:
	HeapElement < T > ** ToMyRoot = & root;
	HeapElement < T > * MyRoot = root;
	HeapElement < T > * NewRoot;
	HeapElement < T > * swap;
		
	while ( true )
	{
		if ( MyRoot -> left == NULL )
			return;
			
		if ( MyRoot -> right == NULL )
			//	nur ein Sohn.
			if ( MyRoot -> key > MyRoot -> left -> key )
			{	
				//	falsche Reihenfolge:
				NewRoot = MyRoot -> left;	
				*ToMyRoot = NewRoot;
				NewRoot -> left = MyRoot;
				NewRoot -> right = NULL;
				MyRoot -> left = NULL;
				MyRoot -> right = NULL;
				return;
			}
			else
				//	korrekte Reihenfolge
				return;
		
		//	zwei Söhne
		if ( MyRoot -> left -> key > MyRoot -> right -> key )
			//	right.key ist kleiner.
			if ( MyRoot -> key > MyRoot -> right -> key )
			{
				//	falsche reihenfolge:
				NewRoot = MyRoot -> right;
				*ToMyRoot = NewRoot;
				MyRoot -> right = NewRoot -> right;
				NewRoot -> right = MyRoot;
				swap = MyRoot -> left;
				MyRoot -> left = NewRoot -> left;
				NewRoot -> left = swap;
				ToMyRoot = & ( NewRoot -> right );
			}
			else
				//	Alles OK
				return;
		else
			//	left.key ist kleiner
			if ( MyRoot -> key > MyRoot -> left -> key )
			{
				//	falsche reihenfolge.
				NewRoot = MyRoot -> left;
				*ToMyRoot = NewRoot;
				MyRoot -> left = NewRoot -> left;
				NewRoot -> left = MyRoot;
				swap = MyRoot -> right;
				MyRoot -> right = NewRoot -> right;
				NewRoot -> right = swap;
				ToMyRoot = & ( NewRoot -> left );
			}
			else
				//	alles OK
				return;
	};
};
 
 
 
// // // // // // // // // // // // // // // //
//
//	RemoveLeft:
//

template < class T >

HeapElement < T > * Heap < T > :: RemoveLeft ()
{
	if ( root == NULL )
		return NULL; 
		
	//	MyRoot:
	HeapElement < T > ** ToMyRoot = & root;
	HeapElement < T > * MyRoot = root;
	HeapElement < T > * swap;

	while ( true )
	{
		if ( MyRoot -> left == NULL )
		{
			//	fertig:
			*ToMyRoot = NULL;
			return MyRoot;
		};
		
		//	Teilbaum-Tausch
		swap = MyRoot -> left;
		MyRoot -> left = MyRoot -> right;
		MyRoot -> right = swap;
		ToMyRoot = & ( MyRoot -> right );
		MyRoot = *ToMyRoot;
	};
};



// // // // // // // // // // // // // // // //
//
//	DeleteMin:
//

template < class T >

HeapElement < T > * Heap < T > :: DeleteMin ()
{
	//	Parametercheck:
	if ( root == NULL )
		return NULL;
	HeapElement < T > * Min = root;
	if ( root -> left == NULL )
	{
		root = NULL;
		return Min;
	};
	HeapElement < T > * Found = RemoveLeft ();
	Found -> left = root -> left;
	Found -> right = root -> right;
	root = Found;
	SiftDown ();
	Min -> left = NULL;
	Min -> right = NULL;
	return Min;
};



#endif



//
//	Ende
//
// // // // // // // // // // // // // // // //
